// OPENCASCADE INCLUDES
/*
#include <FoundationClasses/Standard/_Standard.hxx>
#include <FoundationClasses/gp/Pnt.hxx>
#include <FoundationClasses/gp/Pln.hxx>
#include <FoundationClasses/gp/Pnt2d.hxx>
#include <FoundationClasses/TCollection/AsciiString.hxx>
#include <FoundationClasses/ElSLib/_ElSLib.hxx>
#include <FoundationClasses/Precision/_Precision.hxx>

#include <ModelingData/ProjLib/_ProjLib.hxx>
#include <ModelingData/TopoDS/Shape.hxx>
#include <ModelingData/TopoDS/Solid.hxx>
#include <ModelingData/TopoDS/Edge.hxx>

#include <ModelingAlgorithms/BRepPrimAPI/MakeBox.hxx>
#include <ModelingAlgorithms/BRepPrimAPI/MakeCylinder.hxx>
#include <ModelingAlgorithms/BRepPrimAPI/MakeSphere.hxx>
#include <ModelingAlgorithms/BRepPrimAPI/MakeCone.hxx>
#include <ModelingAlgorithms/BRepBuilderAPI/MakeEdge.hxx>
#include <ModelingAlgorithms/BRepBuilderAPI/MakeFace.hxx>

#include <Visualization/AIS/Shape.hxx>
#include <Visualization/V3d/View.hxx>
#include <Visualization/V3d/Coordinate.hxx>
#include <Visualization/V3d/AmbientLight.hxx>
#include <Visualization/V3d/SpotLight.hxx>
#include <Visualization/V3d/PositionalLight.hxx>
#include <Visualization/V3d/DirectionalLight.hxx>
#include <Visualization/V3d/Plane.hxx>

#ifdef WNT
#include <WNT_Window.hxx>
#include <Visualization/Graphic3d/WNTGraphicDevice.hxx>
#else
#include <Visualization/Xw/Window.hxx>
#include <Visualization/Graphic3d/GraphicDevice.hxx>
#endif  // WNT
*/

#include "TestOpenCascade.h"
//#include "MakeBottle.h"

/*
#ifdef WNT
static Handle(Graphic3d_WNTGraphicDevice) defaultdevice;
#else
static Handle(Graphic3d_GraphicDevice) defaultdevice;
#endif  // WNT


Handle(V3d_AmbientLight) myCurrent_AmbientLight;
Handle(V3d_SpotLight) myCurrent_SpotLight;
Handle(V3d_PositionalLight) myCurrent_PositionalLight;
Handle(V3d_DirectionalLight) myCurrent_DirectionalLight;
Handle(V3d_Plane) myPlane;
Handle(AIS_Shape) myShape;


gp_Pnt p1, p2, p3;
Handle(AIS_Shape) spotConeShape=new AIS_Shape(TopoDS_Solid());
Handle(AIS_Shape) directionalEdgeShape=new AIS_Shape(TopoDS_Edge());

Standard_Boolean isConeDisplayed = Standard_False;
Standard_Boolean isEdgeDisplayed = Standard_False;
*/

#define IMAGEFILE <TestOpenCascade/TestOpenCascade.iml>
#include <Draw/iml_source.h>

// Constructor class TestOpenCascade
TestOpenCascade::TestOpenCascade()
{
	Document = new CascadeDocument;
	View = new CascadeView(Document);
//View = new X11_DHCtrl();
//View = new Ctrl();
	
	View->SetFrame(InsetFrame());
	Add(View->HSizePos(10, 10).VSizePos(10, 10));
	Sizeable().Zoomable();
	
} // END Constructor class TestOpenCascade

// Destructor class TestOpenCascade
TestOpenCascade::~TestOpenCascade()
{
	delete View;
	delete Document;
	
} // END Destructor class TestOpenCascade

// Close() Handler
void TestOpenCascade::Close()
{
	delete this;

} // END TestOpenCascade::Close()

GUI_APP_MAIN
{
	//setenv("CSF_GraphicShr", "/usr/lib/libGL", 1);
	setenv("CASROOT", "/opt/OpenCASCADE6.2.0/ros", 1);
	
	TestOpenCascade *win;
	win = new TestOpenCascade;
	win->OpenMain();
    Ctrl::EventLoop();
}

